' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa AppConfiguaration zawiera waciwoci tylko do odczytu, ktre w zasadzie stanowi skrty do ustawie w pliku web.config.
''' </summary>
Public Class AppConfiguration

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy AppConfiguration.
  ''' </summary>
  Private Sub New()
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Zwraca acuch poczenia dla aplikacji WebShop.
  ''' </summary>
  Public Shared ReadOnly Property ConnectionString() As String
    Get
      Dim tempValue As String = "server=(local)\SqlExpress;AttachDbFileName=|DataDirectory|WebShop.mdf;Integrated Security=true;User Instance=true"
      Try
        If ConfigurationManager.ConnectionStrings("WebShop") IsNot Nothing Then
          tempValue = ConfigurationManager.ConnectionStrings("WebShop").ConnectionString
        End If
      Catch ex As Exception
        ' Jeli nie moemy pobra ustawienia z pliku konfiguracyjnego, ignorujemy bd i zwracamy
        ' domylny acuch poaczenia wskazujcy na instancj SqlExpress na lokalnym 
        ' komputerze i prbujemy poczy si z baz danych WebShop automatycznie.
      End Try
      Return tempValue
    End Get
  End Property


  Public Shared ReadOnly Property ConfirmationMessageLocation() As String
    Get
      Dim tempValue As String = "~/StaticText/ConfirmationMessage.txt"
      Try
        If ConfigurationManager.AppSettings.Get("ConfirmationMessageLocation") _
                IsNot Nothing Then
          tempValue = _
                ConfigurationManager.AppSettings.Get("ConfirmationMessageLocation")
        End If
      Catch ex As Exception
      End Try
      Return HttpContext.Current.Server.MapPath(tempValue)
    End Get
  End Property


#End Region

End Class
